//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2006 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace SID_monitor
{
    public partial class PanelForecast : UserControl
    {
        public PanelForecast()
        {
            InitializeComponent();

            if ( SID_monitor.Properties.Settings.Default.ForecastAlpha <= 0 )
            {
                this.numericUpDownAlpha.Value = 0.01M;
            }
            else if ( SID_monitor.Properties.Settings.Default.ForecastAlpha >= 100 )
            {
                this.numericUpDownAlpha.Value = 0.99M;
            }
            else
            {
                this.numericUpDownAlpha.Value =  SID_monitor.Properties.Settings.Default.ForecastAlpha / 100.0M;
            }

            if ( SID_monitor.Properties.Settings.Default.ForecastBeta <= 0 )
            {
                this.numericUpDownBeta.Value = 0.01M;
            }
            else if ( SID_monitor.Properties.Settings.Default.ForecastBeta >= 100 )
            {
                this.numericUpDownBeta.Value = 0.99M;
            }
            else
            {
                this.numericUpDownBeta.Value = SID_monitor.Properties.Settings.Default.ForecastBeta / 100.0M;
            }

            if ( SID_monitor.Properties.Settings.Default.ForecastGammaSeasonal <= 0 )
            {
                this.numericUpDownGammaSeasonal.Value = 0.01M;
            }
            else if ( SID_monitor.Properties.Settings.Default.ForecastGammaSeasonal >= 100 )
            {
                this.numericUpDownGammaSeasonal.Value = 0.99M;
            }
            else
            {
                this.numericUpDownGammaSeasonal.Value = SID_monitor.Properties.Settings.Default.ForecastGammaSeasonal / 100.0M;
            }

            if ( SID_monitor.Properties.Settings.Default.ForecastGammaDevSeasonal <= 0 )
            {
                this.numericUpDownGammaDevSeasonal.Value = 0.01M;
            }
            else if ( SID_monitor.Properties.Settings.Default.ForecastGammaDevSeasonal >= 100 )
            {
                this.numericUpDownGammaDevSeasonal.Value = 0.99M;
            }
            else
            {
                this.numericUpDownGammaDevSeasonal.Value = SID_monitor.Properties.Settings.Default.ForecastGammaDevSeasonal / 100.0M;
            }

            if (SID_monitor.Properties.Settings.Default.DeltaPos < 1)
            {
                this.numericUpDownDeltaPos.Value = 1;
            }
            else if (SID_monitor.Properties.Settings.Default.DeltaPos > 5)
            {
                this.numericUpDownDeltaPos.Value = 5;
            }
            else
            {
                this.numericUpDownDeltaPos.Value = SID_monitor.Properties.Settings.Default.DeltaPos;
            }

            if (SID_monitor.Properties.Settings.Default.DeltaNeg < 1)
            {
                this.numericUpDownDeltaNeg.Value = 1;
            }
            else if (SID_monitor.Properties.Settings.Default.DeltaNeg > 5)
            {
                this.numericUpDownDeltaNeg.Value = 5;
            }
            else
            {
                this.numericUpDownDeltaNeg.Value = SID_monitor.Properties.Settings.Default.DeltaNeg;
            }

            if (SID_monitor.Properties.Settings.Default.ForecastThreshold < 1)
            {
                this.numericUpDownThreshold.Value = 1;
            }
            else if ( SID_monitor.Properties.Settings.Default.ForecastThreshold > 28 )
            {
                this.numericUpDownThreshold.Value = 28;
            }
            else
            {
                this.numericUpDownThreshold.Value = SID_monitor.Properties.Settings.Default.ForecastThreshold;
            }

            if ( SID_monitor.Properties.Settings.Default.ForecastWindowLength < 1 )
            {
                this.numericUpDownWindowLength.Value = 1;
            }
            else if ( SID_monitor.Properties.Settings.Default.ForecastWindowLength > 28 )
            {
                this.numericUpDownWindowLength.Value = 28;
            }
            else
            {
                this.numericUpDownWindowLength.Value = SID_monitor.Properties.Settings.Default.ForecastWindowLength;
            }

        }

        #region PanelForecast Methods
        private void PanelForecast_Load(object sender, EventArgs e)
        {

            //set tooltips
            toolTipHelp.SetToolTip(labelAlpha, Options_Panels.PanelForecastHelp.AlphaHelp);
            toolTipHelp.SetToolTip(numericUpDownAlpha, Options_Panels.PanelForecastHelp.AlphaHelp);
            toolTipHelp.SetToolTip(trackBarAlpha, Options_Panels.PanelForecastHelp.AlphaHelp);

            toolTipHelp.SetToolTip(labelBeta, Options_Panels.PanelForecastHelp.BetaHelp);
            toolTipHelp.SetToolTip(numericUpDownBeta, Options_Panels.PanelForecastHelp.BetaHelp);
            toolTipHelp.SetToolTip(trackBarBeta, Options_Panels.PanelForecastHelp.BetaHelp);

            toolTipHelp.SetToolTip(labelGammaSeasonal, Options_Panels.PanelForecastHelp.GammaHelp);
            toolTipHelp.SetToolTip(numericUpDownGammaSeasonal, Options_Panels.PanelForecastHelp.GammaHelp);
            toolTipHelp.SetToolTip(trackBarGammaSeasonal, Options_Panels.PanelForecastHelp.GammaHelp);

            toolTipHelp.SetToolTip(labelGammaDevSeasonal, Options_Panels.PanelForecastHelp.GammaDevHelp);
            toolTipHelp.SetToolTip(numericUpDownGammaDevSeasonal, Options_Panels.PanelForecastHelp.GammaDevHelp);
            toolTipHelp.SetToolTip(trackBarGammaDevSeasonal, Options_Panels.PanelForecastHelp.GammaDevHelp);

            toolTipHelp.SetToolTip(labelDeltaPos, Options_Panels.PanelForecastHelp.DeltaPosHelp);
            toolTipHelp.SetToolTip(numericUpDownDeltaPos, Options_Panels.PanelForecastHelp.DeltaPosHelp);
            toolTipHelp.SetToolTip(trackBarDeltaPos, Options_Panels.PanelForecastHelp.DeltaPosHelp);

            toolTipHelp.SetToolTip(labelDeltaNeg, Options_Panels.PanelForecastHelp.DeltaNegHelp);
            toolTipHelp.SetToolTip(numericUpDownDeltaNeg, Options_Panels.PanelForecastHelp.DeltaNegHelp);
            toolTipHelp.SetToolTip(trackBarDeltaNeg, Options_Panels.PanelForecastHelp.DeltaNegHelp);

            toolTipHelp.SetToolTip(labelThreshold, Options_Panels.PanelForecastHelp.ThresholdHelp);
            toolTipHelp.SetToolTip(numericUpDownThreshold, Options_Panels.PanelForecastHelp.ThresholdHelp);
            toolTipHelp.SetToolTip(trackBarThreshold, Options_Panels.PanelForecastHelp.ThresholdHelp);

            toolTipHelp.SetToolTip(labelWindowLength, Options_Panels.PanelForecastHelp.WindowLengthHelp);
            toolTipHelp.SetToolTip(numericUpDownWindowLength, Options_Panels.PanelForecastHelp.WindowLengthHelp);
            toolTipHelp.SetToolTip(trackBarWindowLength, Options_Panels.PanelForecastHelp.WindowLengthHelp);

        }
        #endregion

        #region Alpha numeric up-down and trackbar synchronisation
        /// <summary>
        /// We synchronise the numericUpdown.
        /// </summary>
        private void trackBarAlpha_Scroll(object sender, EventArgs e)
        {
            if ( this.numericUpDownAlpha.Value != (decimal)( this.trackBarAlpha.Value / 100.0 ) )
            {
                this.numericUpDownAlpha.Value = (decimal)( this.trackBarAlpha.Value / 100.0 );
            }
        }

        /// <summary>
        /// We synchronise the trackBar.
        /// </summary>
        private void numericUpDownAlpha_ValueChanged(object sender, EventArgs e)
        {
            if ( this.trackBarAlpha.Value != (int)( this.numericUpDownAlpha.Value * 100 ) )
            {
                this.trackBarAlpha.Value = (int)( this.numericUpDownAlpha.Value * 100 );
            }
        }
        #endregion

        #region Beta numeric up-down and trackbar synchronisation
        /// <summary>
        /// We synchronise the numericUpdown.
        /// </summary>
        private void trackBarBeta_Scroll(object sender, EventArgs e)
        {
            if ( this.numericUpDownBeta.Value != (decimal)( this.trackBarBeta.Value / 100.0 ) )
            {
                this.numericUpDownBeta.Value = (decimal)( this.trackBarBeta.Value / 100.0 );
            }
        }

        /// <summary>
        /// We synchronise the trackBar.
        /// </summary>
        private void numericUpDownBeta_ValueChanged(object sender, EventArgs e)
        {
            if ( this.trackBarBeta.Value != (int)( this.numericUpDownBeta.Value * 100 ) )
            {
                this.trackBarBeta.Value = (int)( this.numericUpDownBeta.Value * 100 );
            }
        }
        #endregion

        #region GammaSeasonal numeric up-down and trackbar synchronisation
        /// <summary>
        /// We synchronise the numericUpdown.
        /// </summary>
        private void trackBarGammaSeasonal_Scroll(object sender, EventArgs e)
        {
            if ( this.numericUpDownGammaSeasonal.Value != (decimal)( this.trackBarGammaSeasonal.Value / 100.0 ) )
            {
                this.numericUpDownGammaSeasonal.Value = (decimal)( this.trackBarGammaSeasonal.Value / 100.0 );
            }
        }

        /// <summary>
        /// We synchronise the trackBar.
        /// </summary>
        private void numericUpDownGammaSeasonal_ValueChanged(object sender, EventArgs e)
        {
            if ( this.trackBarGammaSeasonal.Value != (int)( this.numericUpDownGammaSeasonal.Value * 100 ) )
            {
                this.trackBarGammaSeasonal.Value = (int)( this.numericUpDownGammaSeasonal.Value * 100 );
            }
        }
        #endregion

        #region GammaDevSeasonal numeric up-down and trackbar synchronisation
        /// <summary>
        /// We synchronise the numericUpdown.
        /// </summary>
        private void trackBarGammaDevSeasonal_Scroll(object sender, EventArgs e)
        {
            if ( this.numericUpDownGammaDevSeasonal.Value != (decimal)( this.trackBarGammaDevSeasonal.Value / 100.0 ) )
            {
                this.numericUpDownGammaDevSeasonal.Value = (decimal)( this.trackBarGammaDevSeasonal.Value / 100.0 );
            }
        }

        /// <summary>
        /// We synchronise the trackBar.
        /// </summary>
        private void numericUpDownGammaDevSeasonal_ValueChanged(object sender, EventArgs e)
        {
            if ( this.trackBarGammaDevSeasonal.Value != (int)( this.numericUpDownGammaDevSeasonal.Value * 100 ) )
            {
                this.trackBarGammaDevSeasonal.Value = (int)( this.numericUpDownGammaDevSeasonal.Value * 100 );
            }
        }
        #endregion

        #region DeltaPos numeric up-down and trackbar synchronisation
        /// <summary>
        /// We synchronise the numericUpDown.
        /// </summary>
        private void trackBarDeltaPos_Scroll(object sender, EventArgs e)
        {
            if (this.numericUpDownDeltaPos.Value != (decimal)this.trackBarDeltaPos.Value)
            {
                this.numericUpDownDeltaPos.Value = (decimal)this.trackBarDeltaPos.Value;
            }
        }

        /// <summary>
        /// We synchronise the trackBar.
        /// </summary>
        private void numericUpDownDeltaPos_ValueChanged(object sender, EventArgs e)
        {
            if (this.trackBarDeltaPos.Value != (int)this.numericUpDownDeltaPos.Value)
            {
                this.trackBarDeltaPos.Value = (int)this.numericUpDownDeltaPos.Value;
            }
        }
        #endregion

        #region DeltaNeg numeric up-down and trackbar synchronisation
        /// <summary>
        /// We synchronise the numericUpDown.
        /// </summary>

        private void trackBarDeltaNeg_Scroll(object sender, EventArgs e)
        {
            if (this.numericUpDownDeltaNeg.Value != (decimal)this.trackBarDeltaNeg.Value)
            {
                this.numericUpDownDeltaNeg.Value = (decimal)this.trackBarDeltaNeg.Value;
            }
        }

        /// <summary>
        /// We synchronise the trackBar.
        /// </summary>
        private void numericUpDownDeltaNeg_ValueChanged(object sender, EventArgs e)
        {
            if (this.trackBarDeltaNeg.Value != (int)this.numericUpDownDeltaNeg.Value)
            {
                this.trackBarDeltaNeg.Value = (int)this.numericUpDownDeltaNeg.Value;
            }
        }
        #endregion

        #region Threshold numeric up-down and trackbar synchronisation
        /// <summary>
        /// We synchronise the numericUpDown.
        /// </summary>
        private void trackBarThreshold_Scroll(object sender, EventArgs e)
        {
            if ( this.numericUpDownThreshold.Value != (decimal)this.trackBarThreshold.Value )
            {
                this.numericUpDownThreshold.Value = (decimal)this.trackBarThreshold.Value;
            }
        }

        /// <summary>
        /// We synchronise the trackBar.
        /// The window length cannot be lower than the threshold
        /// </summary>
        private void numericUpDownThreshold_ValueChanged(object sender, EventArgs e)
        {
            if ( this.trackBarThreshold.Value != (int)this.numericUpDownThreshold.Value )
            {
                this.trackBarThreshold.Value = (int)this.numericUpDownThreshold.Value;
            }

            if ( this.numericUpDownThreshold.Value > this.numericUpDownWindowLength.Value )
            {
                this.numericUpDownWindowLength.Value = this.numericUpDownThreshold.Value;
            }

        }
        #endregion

        #region Window Length numeric up-down and trackbar synchronisation
        /// <summary>
        /// We synchronise the numericUpDown.
        /// The window length cannot be lower than the threshold
        /// </summary>
        private void trackBarWindowLength_Scroll(object sender, EventArgs e)
        {
            if ( this.numericUpDownWindowLength.Value != (decimal)this.trackBarWindowLength.Value )
            {
                this.numericUpDownWindowLength.Value = (decimal)this.trackBarWindowLength.Value;
            }
        }

        /// <summary>
        /// We synchronise the trackBar.
        /// The window length cannot be lower than the threshold
        /// </summary>
        private void numericUpDownWindowLength_ValueChanged(object sender, EventArgs e)
        {
            if ( this.trackBarWindowLength.Value != (int)this.numericUpDownWindowLength.Value )
            {
                this.trackBarWindowLength.Value = (int)this.numericUpDownWindowLength.Value;
            }

            if ( this.numericUpDownWindowLength.Value < this.numericUpDownThreshold.Value )
            {
                this.numericUpDownThreshold.Value = this.numericUpDownWindowLength.Value;
            }
        }
        #endregion

        #region Properties
        public int ForecastAlpha
        {
            get
            {
                return (int)this.trackBarAlpha.Value;
            }
        }


        public int ForecastBeta
        {
            get
            {
                return (int)this.trackBarBeta.Value;
            }
        }

        public int ForecastGammaSeasonal
        {
            get
            {
                return (int)this.trackBarGammaSeasonal.Value;
            }
        }

        public int ForecastGammaDevSeasonal
        {
            get
            {
                return (int)this.trackBarGammaDevSeasonal.Value;
            }
        }

        public int DeltaPos
        {
            get
            {
                return (int)this.trackBarDeltaPos.Value;
            }
        }

        public int DeltaNeg
        {
            get
            {
                return (int)this.trackBarDeltaNeg.Value;
            }
        }

        public int ForecastThreshold
        {
            get
            {
                return (int)this.trackBarThreshold.Value;
            }
        }

        public int ForecastWindowLength
        {
            get
            {
                return (int)this.trackBarWindowLength.Value;
            }
        }
        #endregion

        #region ValidData Event
        public event ValidDataEventHandler ValidData;

        protected virtual void OnValidData(validDataEventArgs e)
        {
            if ( ValidData != null )
            {
                // Invokes the delegates. 
                ValidData(this, e);
            }
        }
        #endregion

      


    }
}
